/*
 * SystemCommandJob.hpp
 *
 * Originally taken from my JobMarket project at 1.1.4.
 *
 *  Created on: Feb 5, 2011
 *      Author: heber
 */

#ifndef SYSTEMCOMMANDJOB_HPP_
#define SYSTEMCOMMANDJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/serialization/export.hpp>

#include <string>

#ifdef HAVE_JOBMARKET
#include "JobMarket/Jobs/FragmentJob.hpp"
#else
#include "Jobs/JobMarket/FragmentJob.hpp"
#endif

class SystemCommandJobTest;

/** SystemCommandJob is an extension of FragmentJob that executes a system
 * command operating onto a specific outputfile.
 *
 * Implement extractResult() to get the desired result from the captured
 * output of the system command.
 *
 * Important is that this class is fully serializable such that it can be
 * transfered to a scheduler (server) and be deserialized by the Worker.
 */
class SystemCommandJob : public FragmentJob
{
  //!> grant unit test access
  friend class SystemCommandJobTest;
public:
  SystemCommandJob(const std::string &_command, const std::string &_outputfile, const JobId_t _JobId, const std::string &_suffix = std::string(""));
  virtual ~SystemCommandJob();

  FragmentResult::ptr Work();

  bool operator==(const SystemCommandJob &other) const;

  bool operator!=(const SystemCommandJob &other) const {
    return !(*this == other);
  }

  const std::string& getOutputfile() const {
    return outputfile;
  }

  const std::string& getCommand() const {
    return command;
  }

protected:
  virtual FragmentResult::ptr extractResult(const std::string &resultstring);

  //!> string containing the command to launch the solver
  std::string command;

  //!> suffix to be appended to output file name
  std::string suffix;

  //!> string containing the configuration file for the solver
  std::string outputfile;

protected:
  //!> private default cstor for serialization only
  SystemCommandJob();

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<FragmentJob>(*this);
    ar & command;
    ar & outputfile;
  }
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(SystemCommandJob)

#endif /* SYSTEMCOMMANDJOB_HPP_ */
