/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RotateAroundOriginByAngleAction.cpp
 *
 *  Created on: Aug 06, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Line.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "molecule.hpp"


#include <cmath>
#include <iostream>
#include <fstream>
#include <string>

#include "Actions/AtomAction/RotateAroundOriginByAngleAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "RotateAroundOriginByAngleAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr AtomRotateAroundOriginByAngleAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // check whether Axis is valid
  if (params.Axis.get().IsZero())
    return Action::failure;

  // convert from degrees to radian
  double radian = params.angle.get() * M_PI/180.;

  // Creation Line that is the rotation axis
  Line RotationAxis(Vector(0.,0.,0.), params.Axis.get());

  LOG(0, "Rotate around origin by " << radian << " radian, axis from origin to " << params.Axis.get() << ".");
  // TODO: use AtomSet::rotate?
  for (std::vector<atom *>::iterator iter = selectedAtoms.begin(); iter != selectedAtoms.end(); ++iter) {
    (*iter)->setPosition(RotationAxis.rotateVector((*iter)->getPosition(), radian));
  }
  LOG(0, "done.");
  return Action::state_ptr(new AtomRotateAroundOriginByAngleState(World::getInstance().getSelectedAtoms(), params));
}

Action::state_ptr AtomRotateAroundOriginByAngleAction::performUndo(Action::state_ptr _state) {
  AtomRotateAroundOriginByAngleState *state = assert_cast<AtomRotateAroundOriginByAngleState*>(_state.get());

  // convert from degrees to radian
  double radian = params.angle.get() * M_PI/180.;

  // Creation Line that is the rotation axis
  Line RotationAxis(Vector(0.,0.,0.), state->params.Axis.get());

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    (*iter)->setPosition(RotationAxis.rotateVector((*iter)->getPosition(), -radian));
  }

  return Action::state_ptr(_state);
}

Action::state_ptr AtomRotateAroundOriginByAngleAction::performRedo(Action::state_ptr _state){
  AtomRotateAroundOriginByAngleState *state = assert_cast<AtomRotateAroundOriginByAngleState*>(_state.get());

  // convert from degrees to radian
  double radian = params.angle.get() * M_PI/180.;

  // Creation Line that is the rotation axis
  Line RotationAxis(Vector(0.,0.,0.), state->params.Axis.get());

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    (*iter)->setPosition(RotationAxis.rotateVector((*iter)->getPosition(), radian));
  }

  return Action::state_ptr(_state);
}

bool AtomRotateAroundOriginByAngleAction::canUndo() {
  return true;
}

bool AtomRotateAroundOriginByAngleAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
