/*
 * FillerUnitTest.hpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */

#ifndef FILLERUNITTEST_HPP_
#define FILLERUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <boost/shared_ptr.hpp>

#include "types.hpp"

class atom;
class Cluster;
class Filler;
class FillPredicate;
class Mesh;
class Shape;
class ClusterInterface;
typedef boost::shared_ptr<ClusterInterface> Cluster_impl;

/********************************************** Test classes **************************************/

class FillerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( FillerTest) ;
    CPPUNIT_TEST ( operatorTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void operatorTest();

private:
      FillPredicate *predicate;
      Mesh *mesh;
      Filler *filler;
      atom * _atom;
      Shape *s;
      const element * hydrogen;
      Cluster_impl *cluster;
};

#endif /* FILLERUNITTEST_HPP_ */
