/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */
/*
 * RandomNumberDistributionFactoryUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */
// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>
#include "CodePatterns/Assert.hpp"

#include "RandomNumberDistributionFactoryUnitTest.hpp"

#include "RandomNumbers/RandomNumberDistribution.hpp"
#include "RandomNumbers/RandomNumberDistribution_Encapsulation.hpp"
#include "RandomNumbers/RandomNumberDistributionFactory.hpp"

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/additive_combine.hpp>
#include <boost/random/discard_block.hpp>
#include <boost/random/inversive_congruential.hpp>
#include <boost/random/lagged_fibonacci.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/linear_feedback_shift.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/random_number_generator.hpp>
#include <boost/random/ranlux.hpp>
#include <boost/random/shuffle_output.hpp>
#include <boost/random/subtract_with_carry.hpp>
#include <boost/random/xor_combine.hpp>
#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include <typeinfo>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( RandomNumberDistributionFactoryTest );

void RandomNumberDistributionFactoryTest::setUp()
{
  rndA = NULL;
  rndA_1 = NULL;
  rndA_2 = NULL;
  rndA_3 = NULL;
  RandomNumberDistributionFactory::getInstance();
}

void RandomNumberDistributionFactoryTest::tearDown()
{
  delete rndA;
  delete rndA_1;
  delete rndA_2;
  delete rndA_3;
  RandomNumberDistributionFactory::purgeInstance();
}

void RandomNumberDistributionFactoryTest::DistributionTest()
{
  // check the injectiveness of enum and string map
  for (RandomNumberDistributionFactory::NameMap::const_iterator
      iter = RandomNumberDistributionFactory::getInstance().names.begin();
      iter != RandomNumberDistributionFactory::getInstance().names.end();
      ++iter) {
    CPPUNIT_ASSERT_EQUAL(
        iter->second,
        RandomNumberDistributionFactory::getInstance().getName(
            RandomNumberDistributionFactory::getInstance().getEnum(
                iter->second
            )
        )
    );
  }

  // check one of the distributions in the table
  rndA = RandomNumberDistributionFactory::getInstance().
      ManipulablePrototypeTable[RandomNumberDistributionFactory::uniform_smallint]->clone();
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(boost::uniform_smallint<> ).name()),
      rndA->name()
  );

  // check min and max of uniform_smallint
  CPPUNIT_ASSERT_EQUAL( 0., rndA->min() );
  CPPUNIT_ASSERT_EQUAL( 9., rndA->max() );
}

void RandomNumberDistributionFactoryTest::PrototypeManipulationTest()
{
  // make unmodified clone
  rndA_1 = RandomNumberDistributionFactory::getInstance().
      getProduct(RandomNumberDistributionFactory::uniform_smallint);

  // do something with the prototype
  RandomNumberDistribution_Parameters *params =
      rndA_1->getParameterSet();
  CPPUNIT_ASSERT( 20. != rndA_1->max() );
  params->max = 20.;
  RandomNumberDistributionFactory::getInstance().
      manipulatePrototype(RandomNumberDistributionFactory::uniform_smallint, *params);
  // ... and check max
  rndA_2 = RandomNumberDistributionFactory::getInstance().
      getProduct(RandomNumberDistributionFactory::uniform_smallint);
  CPPUNIT_ASSERT_EQUAL( 20., rndA_2->max());
  CPPUNIT_ASSERT( rndA_1->max() != rndA_2->max());
  // ... and check min (remains the same)
  CPPUNIT_ASSERT( rndA_1->min() == rndA_2->min());

  // do something with the prototype again
  params->max = 25.;
  RandomNumberDistributionFactory::getInstance().
      manipulatePrototype(std::string("uniform_smallint"), *params);
  // ... and check
  rndA_3 = RandomNumberDistributionFactory::getInstance().
      getProduct(RandomNumberDistributionFactory::uniform_smallint);
  CPPUNIT_ASSERT_EQUAL( 25., rndA_3->max());
  CPPUNIT_ASSERT( rndA_1->max() != rndA_3->max());
  CPPUNIT_ASSERT( rndA_2->max() != rndA_3->max());

  delete params;
}
