/*
 * QtMoleculeItem_formula.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_FORMULA_HPP_
#define QTMOLECULEITEM_FORMULA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include <string>

#include "CodePatterns/ObservedValue.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "Formula.hpp"
#include "molecule.hpp"
#include "World.hpp"

class QtMoleculeItemFactory;

/** This class contains the formula of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_formula : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_formula(
      const moleculeId_t _molid,
      const emitDirtyState_t &_emitDirtyState,
      const emitSubjectKilledState_t &_emitSubjectKilledState) :
        QtMoleculeItem(_molid, channellist_formula, QtMoleculeItem::NeedsMove, _emitDirtyState, _emitSubjectKilledState),
        molref(getMolecule()),
        formula(
            molref,
            boost::bind(&QtMoleculeItem_formula::updateFormula, this),
            "MoleculeItem_formula_"+toString(_molid),
            updateFormula(),
            channellist_formula)
  {
    signOnToMolecule();
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  ~QtMoleculeItem_formula()
  {
    signOffFromMolecule();
  }

  std::string updateFormula() const
  {
    const molecule * const mol = getMolecule();
    if (mol != NULL)
      return mol->getFormula().toString();
    else
      return std::string();
  }

  /** Performs the update of the molecule's formula.
   *
   */
  void internal_updateState()
  {
    setText(QString(formula.get().c_str()));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::FORMULA; }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_formula;

  //!> temporary value for molecule
  const molecule * const molref;

  //!> contains visibility state
  ObservedValue<std::string> formula;
};



#endif /* QTMOLECULEITEM_FORMULA_HPP_ */
