/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentResultUnitTest.cpp
 *
 *  Created on: Oct 23, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "FragmentResultUnitTest.hpp"

#include "FragmentResult.hpp"
#include "JobId.hpp"

#include "CodePatterns/Assert.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( FragmentResultTest );


void FragmentResultTest::setUp()
{
  // Throw assertions
  ASSERT_DO(Assert::Throw);
}


void FragmentResultTest::tearDown()
{
}

/** UnitTest for operator==
 */
void FragmentResultTest::equalityTest()
{
  FragmentResult testResult(1);
  FragmentResult sameIdResult(1);
  FragmentResult otherIdResult(2);
  FragmentResult copiedResult(testResult);
  FragmentResult copiedchangedResult(testResult);
  copiedchangedResult.setId(3);

  CPPUNIT_ASSERT( testResult == sameIdResult );
  CPPUNIT_ASSERT( testResult != otherIdResult );
  CPPUNIT_ASSERT( testResult == copiedResult );
  CPPUNIT_ASSERT( testResult != copiedchangedResult );
}

/** UnitTest for serialization
 */
void FragmentResultTest::serializationTest()
{
  FragmentResult testResult(1);
  // write element to stream
  std::stringstream stream;
  boost::archive::text_oarchive oa(stream);
  oa << testResult;

  //std::cout << "Contents of archive is " << stream.str() << std::endl;

  // create and open an archive for input
  boost::archive::text_iarchive ia(stream);
  // read class state from archive
  FragmentResult otherResult(JobId::IllegalJob);

  ia >> otherResult;

  CPPUNIT_ASSERT (testResult == otherResult);
}

