/*
 * JobId.hpp
 *
 *  Created on: Oct 23, 2011
 *      Author: heber
 */

#ifndef JOBID_HPP_
#define JOBID_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/access.hpp"

#include "types.hpp"

/** Class simply contains an Id along with getter and setter,
 *
 */
class JobId
{
public:
  JobId();
  JobId(const JobId_t id);
  ~JobId();

  enum {
    NoJob = 0,
    IllegalJob = -1
  };

  const JobId_t getId() const;

protected:
  void setId(const JobId_t id);

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & id;
  }

private:
  //!> unique id of this job (used for the temporary filename) and associating result
  JobId_t id;
};

#endif /* JOBID_HPP_ */
