/*
 * ChangeNameAction.cpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/ChangeNameAction.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "molecule.hpp"

/****** MoleculeChangeNameAction *****/

// memento to remember the state when undoing

class MoleculeChangeNameState : public ActionState {
public:
  MoleculeChangeNameState(molecule* _mol,std::string _lastName) :
    mol(_mol),
    lastName(_lastName)
  {}
  molecule* mol;
  std::string lastName;
};

const char MoleculeChangeNameAction::NAME[] = "change-molname";

MoleculeChangeNameAction::MoleculeChangeNameAction() :
  Action(NAME)
{}

MoleculeChangeNameAction::~MoleculeChangeNameAction()
{}

Action::state_ptr MoleculeChangeNameAction::performCall() {
  string filename;
  molecule *mol = NULL;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule(NAME, &mol, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryString("Enter name: ",&filename);

  if(dialog->display()) {
    string oldName = mol->getName();
    mol->setName(filename);
    delete dialog;
    return Action::state_ptr(new MoleculeChangeNameState(mol,oldName));
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeChangeNameAction::performUndo(Action::state_ptr _state) {
  MoleculeChangeNameState *state = assert_cast<MoleculeChangeNameState*>(_state.get());

  string newName = state->mol->getName();
  state->mol->setName(state->lastName);

  return Action::state_ptr(new MoleculeChangeNameState(state->mol,newName));
}

Action::state_ptr MoleculeChangeNameAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeChangeNameAction::canUndo() {
  return true;
}

bool MoleculeChangeNameAction::shouldUndo() {
  return true;
}

const string MoleculeChangeNameAction::getName() {
  return NAME;
}
