/*
 * BaseShapes_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef BASESHAPES_IMPL_HPP_
#define BASESHAPES_IMPL_HPP_

#include "Shapes/Shape_impl.hpp"

class Sphere_impl : public Shape_impl {
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString();
};

class Cuboid_impl : public Shape_impl {
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString();
};

#endif /* BASESHAPES_IMPL_HPP_ */
