/*
 * Tesselation_BoundaryTriangleUnitTest.hpp
 *
 *  Created on: Jan 13, 2010
 *      Author: heber
 */

#ifndef TESSELATION_BOUNDARYTRIANGLEUNITTEST_HPP_
#define TESSELATION_BOUNDARYTRIANGLEUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/*********************************************** includes ***********************************/

#include <cppunit/extensions/HelperMacros.h>

#include <vector>

#include "LinearAlgebra/Vector.hpp"
#include "LinkedCell/linkedcell.hpp"
#include "Tesselation/tesselation.hpp"

class TesselPoint;

/********************************************** Test classes **************************************/

class TesselationBoundaryTriangleTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( TesselationBoundaryTriangleTest) ;
    CPPUNIT_TEST ( IsInsideTriangleTest );
    CPPUNIT_TEST ( IsInsideTriangle_specificTest );
    CPPUNIT_TEST ( GetClosestPointInsideTriangleTest );
    CPPUNIT_TEST ( GetClosestPointInsideTriangle_specificTest );
    CPPUNIT_TEST ( GetClosestPointOnPlaneTest );
    CPPUNIT_TEST ( GetClosestPointOffPlaneTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void IsInsideTriangleTest();
      void IsInsideTriangle_specificTest();
      void GetClosestPointInsideTriangleTest();
      void GetClosestPointInsideTriangle_specificTest();
      void GetClosestPointOnPlaneTest();
      void GetClosestPointOffPlaneTest();

private:
      void createTriangle(const std::vector<Vector> &Vectors);
      void removeTriangle();

      static const double SPHERERADIUS;

      class BoundaryTriangleSet *triangle;
      class BoundaryLineSet *lines[3];
      class BoundaryPointSet *points[3];
      class TesselPoint *tesselpoints[3];
      TesselPointSTLList Corners;
};


#endif /* TESSELATION_BOUNDARYTRIANGLEUNITTEST_HPP_ */
