/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * PairCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Analysis/analysis_correlation.hpp"
#include "CodePatterns/Verbose.hpp"
#include "CodePatterns/Log.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Element/element.hpp"
#include "molecule.hpp"
#include "Element/periodentafel.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AnalysisAction/PairCorrelationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "PairCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisPairCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // obtain information
  getParametersfromValueStorage();

  // execute action
  output.open(params.outputname.string().c_str());
  binoutput.open(params.binoutputname.string().c_str());
  PairCorrelationMap *correlationmap = NULL;
  ASSERT(params.elements.size() == 2,
      "AnalysisPairCorrelationAction::performCall() - Exactly two elements are required for pair correlation.");
  std::vector<const element *>::const_iterator elemiter = params.elements.begin();
  const World::AtomComposite atoms_first = World::getInstance().getAllAtoms(AtomByType(*(elemiter++)));
  const World::AtomComposite atoms_second = World::getInstance().getAllAtoms(AtomByType(*(elemiter++)));
  ASSERT(elemiter == params.elements.end(),
      "AnalysisPairCorrelationAction::performCall() - Exactly two elements are required for pair correlation.");
  double max_distance = params.BinEnd;
  if (params.BinEnd <= 0.) {
    // find max distance within box from diagonal
    const RealSpaceMatrix &Minv = World::getInstance().getDomain().getMinv();
    max_distance = (Minv * Vector(1.,1.,1.)).NormSquared();
  }
  correlationmap = PairCorrelation(atoms_first, atoms_second, max_distance);
  OutputCorrelationMap<PairCorrelationMap>(&output, correlationmap, OutputPairCorrelation_Header, OutputPairCorrelation_Value);
  binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPairCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPairCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
