/*
 * errorLogger.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <fstream>
#include <iostream>
#include "Helpers/errorlogger.hpp"
#include "Helpers/Verbose.hpp"
#include "Patterns/Singleton_impl.hpp"

ofstream null("/dev/null");
int errorLogger::verbosity = 2;
ostream* errorLogger::nix = &null;

/**
 * Constructor. Do not use this function. Use getInstance() instead.
 *
 * \return errorLogger instance
 */
errorLogger::errorLogger()
{};

/**
 * Destructor. Better use purgeInstance().
 */
errorLogger::~errorLogger()
{}

CONSTRUCT_SINGLETON(errorLogger)

/**
 * Sets the verbosity.
 *
 * \param verbosityLevel verbosity
 */
void errorLogger::setVerbosity(int verbosityLevel) {
  verbosity = verbosityLevel;
}

/**
 * Operator for the Binary(arg) call.
 * Constructs temporary a Verbose class object, wherein the Binary is stored.
 * Then << is called, which calls Binary's print which adds the tabs and logs
 * the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Binary object
 * \return &ost
 */
ostream& operator<<(class errorLogger& l, const Verbose& v)
{
  int verbosityLevel = l.verbosity;
  l.nix->clear();
  if (v.DoErrorOutput(verbosityLevel)) {
    switch(v.Verbosity) {
      case 0:
        cerr << "CRITICAL: ";
        break;
      case 1:
        cerr << "ERROR: ";
        break;
      case 2:
        cerr << "WARNING: ";
        break;
      default:
        break;
    }
    v.print(cerr);
    return cerr;
  } else
    return *l.nix;
};
ostream& operator<<(class errorLogger* l, const Verbose& v)
{
  int verbosityLevel = l->verbosity;
  l->nix->clear();
  if (v.DoErrorOutput(verbosityLevel)) {
    switch(v.Verbosity) {
      case 0:
        cerr << "CRITICAL: ";
        break;
      case 1:
        cerr << "ERROR: ";
        break;
      case 2:
      default:
        cerr << "WARNING: ";
        break;
    }
    v.print(cerr);
    return cerr;
  } else
    return *l->nix;
};


