/** \file Verbose.cpp
 *
 * Function implementations for the class Verbose.
 *
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Info.hpp"
#include "Helpers/Verbose.hpp"
#include <iostream>

using namespace std;

/** Prints the tabs according to verbosity stored in the temporary constructed class.
 * \param &ost stream to extend with tabs
 * \return &ost stream with tabs
 */
ostream& Verbose::print (ostream &ost) const
{
  for (int i=Verbosity+Info::verbosity;i--;)
    ost.put('\t');
  //Log() << Verbose(0) << "Verbose(.) called." << endl;
  return ost;
};

/** States whether current output message should be print or not.
 * Compares Verbose::Verbosity plus Info::verbosity against \a verbosityLevel.
 * \param verbosityLevel given global level of verbosity
 * \return true - do output, false - don't
 */
bool Verbose::DoOutput(int verbosityLevel) const
{
  return (verbosityLevel >= Verbosity+Info::verbosity);
};

/** States whether current error output message should be print or not.
 * Compares Verbose::Verbosity against \a verbosityLevel.
 * \param verbosityLevel given global level of verbosity
 * \return true - do output, false - don't
 */
bool Verbose::DoErrorOutput(int verbosityLevel) const
{
  return (verbosityLevel >= Verbosity);
};

/** Operator for the Verbose(arg) call.
 * Constructs temporary a Verbose class object, wherein the verbosity is stored.
 * Then << is called, which calls Verbose's print which adds the tabs and returns the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Verbose object
 * \return &ost
 */ 
ostream& operator<<(ostream& ost,const Verbose& m)
{
  return m.print(ost);
};

/** Prints the tabs according to verbosity stored in the temporary constructed class.
 * Note that highest bit is set artificially to give number of bits to print
 * \param &ost stream to extend with tabs
 * \return &ost stream with tabs
 */
ostream& Binary::print (ostream &ost) const
{
  int bits = 1, counter = 1;
  while ((bits = 1 << counter) < BinaryNumber)
    counter++;
  for (int i=0;i<counter-1;i++) {
    if ((BinaryNumber & (1 << i)) == 0)
      ost.put('0');
     else
      ost.put('1');
  }
  ost.put('b');
  //Log() << Verbose(0) << "Binary(.) called." << endl;
  return ost;
};

/** Operator for the Binary(arg) call.
 * Constructs temporary a Verbose class object, wherein the Binary is stored.
 * Then << is called, which calls Binary's print which adds the tabs and returns the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Binary object
 * \return &ost
 */ 
ostream& operator<<(ostream& ost,const Binary& m)
{
  return m.print(ost);
};
