/*
 * SaveBondsAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SaveBondsAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"


#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** MoleculeSaveBondsAction *****/

// memento to remember the state when undoing

//class MoleculeSaveBondsState : public ActionState {
//public:
//  MoleculeSaveBondsState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSaveBondsAction::NAME[] = "save-bonds";

MoleculeSaveBondsAction::MoleculeSaveBondsAction() :
  Action(NAME)
{}

MoleculeSaveBondsAction::~MoleculeSaveBondsAction()
{}

void MoleculeSaveBonds(std::string &bondsfile) {
  ValueStorage::getInstance().setCurrentValue(MoleculeSaveBondsAction::NAME, bondsfile);
  ActionRegistry::getInstance().getActionByName(MoleculeSaveBondsAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeSaveBondsAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeSaveBondsAction::performCall() {
  string filename;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Storing bonds to path " << filename << "." << endl);
    World::getInstance().getConfig()->BG->ConstructBondGraph(mol);
    // TODO: sollte stream, nicht filenamen direkt nutzen, besser fuer unit tests
    mol->StoreBondsToFile(filename);
  }
  return Action::success;
}

Action::state_ptr MoleculeSaveBondsAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveBondsState *state = assert_cast<MoleculeSaveBondsState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveBondsAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveBondsAction::canUndo() {
  return false;
}

bool MoleculeSaveBondsAction::shouldUndo() {
  return false;
}

const string MoleculeSaveBondsAction::getName() {
  return NAME;
}
