/*
 * QtMoleculeItem.hpp
 *
 *  Created on: Jan 17, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_HPP_
#define QTMOLECULEITEM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QList>
#include <QStandardItem>

#include "CodePatterns/Observer/Observer.hpp"

#include <string>

class molecule;

QList<QStandardItem *> createMoleculeItemRow(const molecule *_mol);

class QtMoleculeItem : public QStandardItem, public Observer
{
public:
  QtMoleculeItem(const molecule *_mol);
  virtual ~QtMoleculeItem();

  static const int COLUMNCOUNT;
  enum {NAME,VISIBILITY,ATOMCOUNT,FORMULA,OCCURRENCE,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

protected:
  virtual void update(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  virtual void subjectKilled(Observable *publisher);

private:
  //!> molecule we are signed on to
  const molecule *mol;
  //!> states whether we are still signed on to molecule
  bool IsSignedOn;
};


#endif /* QTMOLECULEITEM_HPP_ */
