/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LoadXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

using namespace std;

#include "Actions/ParserAction/LoadXyzAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Parser/XyzParser.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <set>
#include <string>
#include <vector>

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** ParserLoadXyzAction *****/

//// memento to remember the state when undoing
//
//class ParserLoadXyzState : public ActionState {
//public:
//  ParserLoadXyzState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char ParserLoadXyzAction::NAME[] = "parse-xyz";

ParserLoadXyzAction::ParserLoadXyzAction() :
  Action(NAME)
{}

ParserLoadXyzAction::~ParserLoadXyzAction()
{}

void ParserLoadXyz(std::string &filename) {
  ValueStorage::getInstance().setCurrentValue(ParserLoadXyzAction::NAME, filename);
  ActionRegistry::getInstance().getActionByName(ParserLoadXyzAction::NAME)->call(Action::NonInteractive);
};

Dialog* ParserLoadXyzAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr ParserLoadXyzAction::performCall() {
  string filename;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  DoLog(1) && (Log() << Verbose(1) << "Parsing xyz file for new atoms." << endl);
  // parse xyz file
  ifstream input;
  input.open(filename.c_str());
  if (!input.fail()) {
    XyzParser parser; // briefly instantiate a parser which is removed at end of focus
    parser.load(&input);
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Could not open file " << filename << "." << endl);
  }
  input.close();
  return Action::success;
}

Action::state_ptr ParserLoadXyzAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserLoadXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserLoadXyzAction::canUndo() {
  return false;
}

bool ParserLoadXyzAction::shouldUndo() {
  return false;
}

const string ParserLoadXyzAction::getName() {
  return NAME;
}
