/*
 * atom_atominfo.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_ATOMINFO_HPP_
#define ATOM_ATOMINFO_HPP_


using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/VectorInterface.hpp"

/****************************************** forward declarations *****************************/

class AtomInfo;
class element;
class RealSpaceMatrix;

/********************************************** declarations *******************************/

class AtomInfo : public VectorInterface {

public:
  AtomInfo();
  AtomInfo(const AtomInfo &_atom);
  AtomInfo(const VectorInterface &_v);
  virtual ~AtomInfo();

  /** Getter for AtomicElement.
   *
   * @return constant reference to AtomicElement
   */
  const element *getType() const;
  /** Setter for AtomicElement.
   *
   * @param _type new element by pointer to set
   */
  void setType(const element *_type);
  /** Setter for AtomicElement.
   *
   * @param _typenr new element by index to set
   */
  void setType(const int _typenr);

  /** Getter for AtomicVelocity.
   *
   * @return constant reference to AtomicVelocity
   */
  Vector& getAtomicVelocity();
  /** Getter for AtomicVelocity.
   *
   * @return constant reference to AtomicVelocity
   */
  const Vector& getAtomicVelocity() const;
  /** Setter for AtomicVelocity.
   *
   * @param _newvelocity new velocity to set
   */
  void setAtomicVelocity(const Vector &_newvelocity);

  /** Getter for AtomicForce.
   *
   * @return constant reference to AtomicForce
   */
  const Vector& getAtomicForce() const;
  /** Setter for AtomicForce.
   *
   * @param _newvelocity new force vector to set
   */
  void setAtomicForce(const Vector &_newforce);

  ///// manipulation of the atomic position

  // Accessors ussually come in pairs... and sometimes even more than that
  const double& operator[](size_t i) const;
  const double& at(size_t i) const;
  void set(size_t i, const double value);
  const Vector& getPosition() const;

  // Assignment operator
  void setPosition(const Vector& _vector);
  class VectorInterface &operator=(const Vector& _vector);

  // operators for mathematical operations
  const VectorInterface& operator+=(const Vector& b);
  const VectorInterface& operator-=(const Vector& b);
  Vector const operator+(const Vector& b) const;
  Vector const operator-(const Vector& b) const;

  void Zero();
  void One(const double one);
  void LinearCombinationOfVectors(const Vector &x1, const Vector &x2, const Vector &x3, const double * const factors);

  double distance(const Vector &point) const;
  double DistanceSquared(const Vector &y) const;
  double distance(const VectorInterface &_atom) const;
  double DistanceSquared(const VectorInterface &_atom) const;

  void ScaleAll(const double *factor);
  void ScaleAll(const Vector &factor);
  void Scale(const double factor);

  std::ostream & operator << (std::ostream &ost) const;

private:
  Vector AtomicPosition;       //!< coordinate vector of atom, giving last position within cell
  Vector AtomicVelocity;       //!< velocity vector of atom, giving last velocity within cell
  Vector AtomicForce;       //!< Force vector of atom, giving last force within cell

  const element *AtomicElement;  //!< pointing to element
};

std::ostream & operator << (std::ostream &ost, const AtomInfo &a);

const AtomInfo& operator*=(AtomInfo& a, const double m);
AtomInfo const operator*(const AtomInfo& a, const double m);
AtomInfo const operator*(const double m, const AtomInfo& a);

#endif /* ATOM_ATOMINFO_HPP_ */
