/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2025 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SetUndoMarkAction.cpp
 *
 *  Created on: Apr 06, 2021
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Actions/CommandAction/SetUndoMarkAction.hpp"

#include "Actions/ActionQueue.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetUndoMarkAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandSetUndoMarkAction::performCall() {
  // set ActionQueue on to last element (hence skipping all in between)

  if (params.doSet.get()) {
    LOG(1, "INFO: Marking current state in action history.");
    ActionQueue::getInstance().setMark();
  } else {
    LOG(1, "INFO: Resetting marked state in action history.");
    ActionQueue::getInstance().unsetMark();
  }

  return Action::success;
}

ActionState::ptr CommandSetUndoMarkAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr CommandSetUndoMarkAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool CommandSetUndoMarkAction::canUndo() {
  return false;
}

bool CommandSetUndoMarkAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
