/*
 * MoleculeNameDescriptor.cpp
 *
 *  Created on: Jun 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "MoleculeNameDescriptor.hpp"
#include "MoleculeNameDescriptor_impl.hpp"

#include "molecule.hpp"

using namespace std;


MoleculeNameDescriptor_impl::MoleculeNameDescriptor_impl(std::string _name) :
  name(_name)
{}

MoleculeNameDescriptor_impl::~MoleculeNameDescriptor_impl()
{}

bool MoleculeNameDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule) {
  return molecule.second->name==name;
}

MoleculeDescriptor MoleculeByName(std::string name){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeNameDescriptor_impl(name)));
}

molecule *MoleculeNameDescriptor_impl::find(){
  World::MoleculeSet &molecules = getMolecules();
  World::MoleculeSet::iterator res = molecules.begin();
  for (; res != molecules.end(); res++)
    if (res->second->name == name)
      break;
  return (res!=molecules.end())?((*res).second):0;
}

vector<molecule*> MoleculeNameDescriptor_impl::findAll(){
  molecule *res = find();
  return (res)?(vector<molecule*>(1,res)):(vector<molecule*>());
}
