/*
 * ShapeOps_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPEOPS_IMPL_HPP_
#define SHAPEOPS_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Shapes/Shape_impl.hpp"
#include "Shapes/ShapeExceptions.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"

#include <vector>

class LineSegment;

class ShapeOpsBase_impl : public Shape_impl{
public:
  ShapeOpsBase_impl(const Shape::impl_ptr&);
  virtual ~ShapeOpsBase_impl();
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw (NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
protected:
  virtual Vector translateIn(const Vector &point)=0;
  virtual Vector translateOutPos(const Vector &point)=0;
  virtual Vector translateOutNormal(const Vector &point)=0;
  Shape::impl_ptr getArg() const;
private:
  Shape::impl_ptr arg;
};

class Resize_impl :  public ShapeOpsBase_impl
{
public:
  Resize_impl(const Shape::impl_ptr&,double);
  virtual ~Resize_impl();
protected:
  virtual Vector translateIn(const Vector &point);
  virtual Vector translateOutPos(const Vector &point);
  virtual Vector translateOutNormal(const Vector &point);
  virtual std::string toString();
  virtual bool isInside(const Vector& point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  double size;
};

class Translate_impl :  public ShapeOpsBase_impl
{
public:
  Translate_impl(const Shape::impl_ptr&, const Vector&);
  virtual ~Translate_impl();
protected:
  virtual Vector translateIn(const Vector &point);
  virtual Vector translateOutPos(const Vector &point);
  virtual Vector translateOutNormal(const Vector &point);
  virtual std::string toString();
  virtual bool isInside(const Vector& point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Vector offset;
};

class Stretch_impl : public ShapeOpsBase_impl
{
public:
  Stretch_impl(const Shape::impl_ptr&, const Vector&);
  virtual ~Stretch_impl();
protected:
  virtual Vector translateIn(const Vector &point);
  virtual Vector translateOutPos(const Vector &point);
  virtual Vector translateOutNormal(const Vector &point);
  virtual std::string toString();
  virtual bool isInside(const Vector& point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Vector factors;
  Vector reciFactors;
};

class Transform_impl : public ShapeOpsBase_impl
{
public:
  Transform_impl(const Shape::impl_ptr&, const RealSpaceMatrix&);
  virtual ~Transform_impl();
protected:
  virtual Vector translateIn(const Vector &point);
  virtual Vector translateOutPos(const Vector &point);
  virtual Vector translateOutNormal(const Vector &point);
  virtual std::string toString();
  virtual bool isInside(const Vector& point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  RealSpaceMatrix transformation;
  RealSpaceMatrix transformationInv;
};

#endif /* SHAPEOPS_IMPL_HPP_ */
