/*
 * Shape.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPE_HPP_
#define SHAPE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/shared_ptr.hpp>
#include <iosfwd>

#include "Shapes/ShapeExceptions.hpp"

#include <vector>

class Vector;
class Shape_impl;
class LineSegmentSet;
class Line;

class Shape
{
public:
  typedef boost::shared_ptr<Shape_impl> impl_ptr;
  friend impl_ptr getShapeImpl(const Shape&);

  Shape(impl_ptr);
  Shape(const Shape&);
  virtual ~Shape();

  bool isInside(const Vector &point) const;
  bool isOnSurface(const Vector &point) const;
  Vector getNormal(const Vector &point) const throw(NotOnSurfaceException);

  LineSegmentSet getLineIntersections(const Line&);
  std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;

  Shape &operator=(const Shape& rhs);

  std::string toString() const;
protected:
  impl_ptr getImpl() const;

private:
  impl_ptr impl;
};

Shape Everywhere();
Shape Nowhere();

Shape operator&&(const Shape&,const Shape&);
Shape operator||(const Shape&,const Shape&);
Shape operator!(const Shape&);

std::ostream &operator<<(std::ostream&,const Shape&);

#endif /* SHAPE_HPP_ */
