/*
 * QTMainWindow.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#include "QTMainWindow.hpp"

#include<Qt/qapplication.h>
#include<Qt/qlabel.h>
#include<Qt/qstring.h>
#include<Qt/qmenubar.h>
#include<Qt/qsplitter.h>

#include<iostream>
#include<boost/bind.hpp>

#include "atom.hpp"
#include "molecule.hpp"
#include "Menu/QT4/QTMenu.hpp"
#include "Views/QT4/QTWorldView.hpp"
#include "Views/QT4/GLMoleculeView.hpp"
#include "Views/QT4/QTMoleculeView.hpp"
#include "Views/QT4/QTStatusBar.hpp"
#include "Helpers/MemDebug.hpp"


using namespace std;

QTMainWindow::QTMainWindow(QApplication *_theApp) :
    theApp(_theApp)
{
  QSplitter *splitter1 = new QSplitter (Qt::Horizontal, this );
  QSplitter *splitter2 = new QSplitter (Qt::Vertical, splitter1 );

  worldDisplay = new QTWorldView(splitter2);

  moleculeDisplay = new QTMoleculeView();
  molecule3dDisplay = new GLMoleculeView();

  QMenuBar *Menu = menuBar();

  setCentralWidget(splitter1);
  splitter1->addWidget(splitter2);
  splitter1->addWidget(moleculeDisplay);
  splitter2->addWidget(molecule3dDisplay);
  splitter2->addWidget(worldDisplay);

  statusBar = new QTStatusBar(this);
  setStatusBar(statusBar);

  connect(worldDisplay,SIGNAL(moleculeSelected(molecule*)),moleculeDisplay,SLOT(moleculeSelected(molecule*)));
  connect(worldDisplay,SIGNAL(moleculeUnSelected(molecule*)),moleculeDisplay,SLOT(moleculeUnSelected(molecule*)));
}

QTMainWindow::~QTMainWindow()
{
  menuBar()->clear();
  delete editMoleculesMenu;
}

void QTMainWindow::display() {
  this->show();
  theApp->exec();
}
