/*
 * QtMoleculeListView.hpp
 *
 *  Created on: Jan 17, 2015
 *      Author: heber
 */

#ifndef QTMOLECULELISTVIEW_HPP_
#define QTMOLECULELISTVIEW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QModelIndex>
#include <QTreeView>

#include "types.hpp"

#include "UIElements/Qt4/InstanceBoard/ObservedValue_types.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

class QtMoleculeList;

class QtMoleculeListView : public QTreeView
{
  Q_OBJECT

public:
  QtMoleculeListView(QWidget * _parent);
  virtual ~QtMoleculeListView();

  void setModel(QtMoleculeList *_moleculelist);

public slots:
  void rowsSelected(const QItemSelection&, const QItemSelection&);
  void selectionChanged(const QtObservedMolecule::ptr _molecule);
  void activateSelections();
  void deactivateSelections();

private:
  void MoleculeSelected(ObservedValue_Index_t _id);
  void MoleculeUnselected(ObservedValue_Index_t _id);

  QModelIndex setIndexToLastColumn(const QModelIndex &_index) const;

  bool selecting;
};


#endif /* QTMOLECULELISTVIEW_HPP_ */
