/*
 * QtMoleculeList.hpp
 *
 *  Created on: Jan 21, 2010
 *      Author: crueger
 */

#ifndef QTMOLECULELIST_HPP_
#define QTMOLECULELIST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QItemSelection>
#include <QtGui/QStandardItem>
#include <QtGui/QStandardItemModel>
#include <QTimer>

#include <boost/bimap.hpp>
#include <boost/thread/recursive_mutex.hpp>
#include <map>
#include <set>
#include <string>

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"
#include "UIElements/Views/Qt4/MoleculeList/QtObservedMoleculeObserver.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

#include "types.hpp"

class QtMoleculeItem;
class QtMoleculeListView;
class QtObservedInstanceBoard;

class QtMoleculeList : public QStandardItemModel
{
  Q_OBJECT

public:
  QtMoleculeList(QtObservedInstanceBoard *_board, QObject *_parent = NULL);
  virtual ~QtMoleculeList();

  void resetUpdateTimer();

  QVariant headerData(int section, Qt::Orientation orientation, int role) const;

private slots:
  void formulaChanged(const QtObservedMolecule::ptr _mol);
  void nameChanged(const QtObservedMolecule::ptr _mol);
  void atomcountChanged(const QtObservedMolecule::ptr _mol);

  void moleculeNameChanged(QStandardItem*);
  void checkForVisibilityChange(QStandardItem*);

signals:
  void moleculesVisibilityChanged(ObservedValue_Index_t, bool);
  void MayStartSelections();
  void MayNotStartSelections();

private slots:
  void moleculeInserted(QtObservedMolecule::ptr _mol);
  void moleculeRemoved(ObservedValue_Index_t _id);

private:
  friend class QtMoleculeListView;

  bool isMoleculeItemPresent(ObservedValue_Index_t _id) const;
  QtMoleculeItem * MoleculeIdToItem(ObservedValue_Index_t _id) const;
  ObservedValue_Index_t ItemToMoleculeId(const QtMoleculeItem * const _item) const;
  const QModelIndex MoleculeIdToIndex(ObservedValue_Index_t _id) const;
  ObservedValue_Index_t IndexToMoleculeId(const QModelIndex &_index) const;
  QtMoleculeItem * getSpecificMoleculeItem(
      const QtMoleculeItem * const _item,
      const enum QtMoleculeItem::COLUMNTYPES _type) const;
  bool isGroupItemPresent(const std::string &_formula) const;
  const std::string& GroupItemToFormula(const QStandardItem * const _item) const;
  QStandardItem * FormulaToGroupItem(const std::string &_formula) const;
  QStandardItem * getSpecificGroupItem(
      const QStandardItem * const _item,
      const enum QtMoleculeItem::COLUMNTYPES _type) const;

  std::string addMolecule(
      QtObservedMolecule::ptr &_ObservedMolecule);
  void addGroupItem(
      QStandardItem *&mainitem,
      const std::string &_molecule_formula);
  QList<QStandardItem *> createMoleculeItems(
      QtObservedMolecule::ptr &_ObservedMolecule,
      std::string &molecule_formula);
  void removeMoleculeItem(QtMoleculeItem * const _item);
  int setOccurrence(QStandardItem * const _groupitem);
  void setVisibilityForMoleculeItem(QtMoleculeItem* _item);
  void setVisibilityForGroupItem(QStandardItem* _item);
  void moveItem(QtMoleculeItem *_molitem, const std::string &_new_formula);

//  void updateItemStates();

  //!> reference to InstanceBoard
  QtObservedInstanceBoard *board;

  typedef std::map<std::string, unsigned int> FormulaVisibilityCountMap_t;
  FormulaVisibilityCountMap_t FormulaVisibilityCountMap;

  typedef boost::bimap<std::string, QStandardItem*> FormulaTreeItemBiMap_t;
  //!> map of (unique) formulas in the world
  FormulaTreeItemBiMap_t FormulaItemBiMap;

  typedef std::map<ObservedValue_Index_t, std::string> MoleculeFormulaMap_t;
  //!> map of (unique) formulas in the world
  MoleculeFormulaMap_t MoleculeFormulaMap;

  typedef boost::bimap<ObservedValue_Index_t, QtMoleculeItem*> MoleculeItemBiMap_t;
  MoleculeItemBiMap_t MoleculeItemBiMap;

  //!> listens to all QtObservedMolecule and relays important events to us
  QtObservedMoleculeObserver observer;
};

#endif /* QTMOLECULELIST_HPP_ */
