/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorPositiveComponentsValidator.cpp
 *
 *  Created on: May 10, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "VectorPositiveComponentsValidator.hpp"

#include "LinearAlgebra/RealSpaceMatrix.hpp"

bool VectorPositiveComponentsValidator::isValid(const Vector & _value) const
{
  bool status = true;
  for (size_t i=0;i<NDIM;++i)
    status = status && (_value[i] > 0);
  return status;
}

bool VectorPositiveComponentsValidator::operator==(const Validator<Vector> &_instance) const
{
  const VectorPositiveComponentsValidator *inst =
      dynamic_cast<const VectorPositiveComponentsValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< Vector >* VectorPositiveComponentsValidator::clone() const
{
  Validator< Vector > *inst =
      new VectorPositiveComponentsValidator();
  return inst;
}




