/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RealSpaceMatrixSymmetricValidator.cpp
 *
 *  Created on: May 10, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "RealSpaceMatrixSymmetricValidator.hpp"

#include "LinearAlgebra/RealSpaceMatrix.hpp"

bool RealSpaceMatrixSymmetricValidator::isValid(const RealSpaceMatrix & _value) const
{
  bool status = true;
  status = status && (_value.at(0,1) == _value.at(1,0));
  status = status && (_value.at(0,2) == _value.at(2,0));
  status = status && (_value.at(1,2) == _value.at(2,1));
  return status;
}

bool RealSpaceMatrixSymmetricValidator::operator==(const Validator<RealSpaceMatrix> &_instance) const
{
  const RealSpaceMatrixSymmetricValidator *inst =
      dynamic_cast<const RealSpaceMatrixSymmetricValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< RealSpaceMatrix >* RealSpaceMatrixSymmetricValidator::clone() const
{
  Validator< RealSpaceMatrix > *inst =
      new RealSpaceMatrixSymmetricValidator();
  return inst;
}




