/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ContinuousParameterTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ContinuousParameterTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parameters/Parameter.hpp"

#include "../Range.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ContinuousParameterTest );


void ContinuousParameterTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  ValidIntRange = new range<int>(1,4);
  ValidVectorRange = new range<Vector>(Vector(0,1,2), Vector(10,11,12));
}

void ContinuousParameterTest::tearDown()
{
  delete ValidIntRange;
  delete ValidVectorRange;
}

/************************************ tests ***********************************/

/** Unit test for comparator.
 *
 */
void ContinuousParameterTest::comparatorTest()
{
  // create instance
  Parameter<int> test("intParam", *ValidIntRange);
  Parameter<int> samenamedsamevalued("intParam", *ValidIntRange);
  Parameter<int> samenamedelsevalued("intParam", *ValidIntRange);
  Parameter<int> elsenamedsamevalued("int2Param", *ValidIntRange);
  Parameter<int> elsenamedelsevalued("int2Param", *ValidIntRange);
  test.set(1);
  samenamedsamevalued.set(1);
  samenamedelsevalued.set(2);
  elsenamedsamevalued.set(1);
  elsenamedelsevalued.set(2);

  CPPUNIT_ASSERT( test == samenamedsamevalued );
  CPPUNIT_ASSERT( test != samenamedelsevalued );
  CPPUNIT_ASSERT( test != elsenamedsamevalued );
  CPPUNIT_ASSERT( test != elsenamedelsevalued );
}

/** Unit test for clone.
 *
 */
void ContinuousParameterTest::cloneTest()
{
  // create instance
  Parameter<int> test("intParam", *ValidIntRange);

  // check that we throw because of unset parameter
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.clone(), Assert::AssertionFailure);
#endif

  // set parameter
  test.set(2);

  // is returned as Parameter but we can compare only in true class as
  // Parameter may also be a DiscreteParameter where comparison is nonsense
  Parameter<int> *instance = dynamic_cast< Parameter<int> *> (test.clone());

  // different places in memory
  CPPUNIT_ASSERT( &test != instance);

  // but same contents
  CPPUNIT_ASSERT( test == *instance);
}

