/*
 * MPQCDataFused.hpp
 *
 *  Created on: 28.07.2012
 *      Author: heber
 */

#ifndef MPQCDATAFUSED_HPP_
#define MPQCDATAFUSED_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/** This namespace contains a key for each data member in MPQCData.
 *
 * We need these keys as enumeration of the data members to allow
 * generic algorithms to work on it.
 *
 * \note forward declarations are not enough as we need the true (but empty)
 * instance when going throughb the list with boost::mpl::for_each.
 */
namespace MPQCDataFused {
  // keys for energy_t
  struct energy_total {};
  struct energy_nuclear_repulsion {};
  struct energy_electron_coulomb {};
  struct energy_electron_exchange {};
  struct energy_correlation {};
  struct energy_overlap {};
  struct energy_kinetic {};
  struct energy_hcore {};
  struct energy_eigenvalues {};

  // keys for forces
  struct forces {};

  // keys for times_t
  struct times_walltime {};
  struct times_cputime {};
  struct times_flops {};
}


#endif /* MPQCDATAFUSED_HPP_ */
