/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllAtomsOfMoleculeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Descriptors/AtomOfMoleculeSelectionDescriptor.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "NotAllAtomsOfMoleculeAction.hpp"

// and construct the stuff
#include "NotAllAtomsOfMoleculeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms of currently selected molecules." << endl);
  std::vector<atom *> unselectedAtoms = World::getInstance().getAllAtoms(!AtomsBySelection());
  World::getInstance().unselectAllAtoms(AtomsByMoleculeSelection());
  return Action::state_ptr(new SelectionNotAllAtomsOfMoleculeState(unselectedAtoms, params));
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsOfMoleculeState *state = assert_cast<SelectionNotAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().selectAllAtoms(AllAtoms());
  BOOST_FOREACH(atom *_atom, state->unselectedAtoms)
    World::getInstance().unselectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performRedo(Action::state_ptr _state){
  //SelectionNotAllAtomsOfMoleculeState *state = assert_cast<SelectionNotAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomsByMoleculeSelection());

  return Action::state_ptr(_state);
}

bool SelectionNotAllAtomsOfMoleculeAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsOfMoleculeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
