/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllAtomsOfMoleculeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Descriptors/AtomOfMoleculeSelectionDescriptor.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "AllAtomsOfMoleculeAction.hpp"

// and construct the stuff
#include "AllAtomsOfMoleculeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsOfMoleculeAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms of currently selected molecule." << endl);
  std::vector<atom *> selectedAtoms = World::getInstance().getAllAtoms(AtomsBySelection());
  World::getInstance().selectAllAtoms(AtomsByMoleculeSelection());
  return Action::state_ptr(new SelectionAllAtomsOfMoleculeState(selectedAtoms, params));
}

Action::state_ptr SelectionAllAtomsOfMoleculeAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsOfMoleculeState *state = assert_cast<SelectionAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().clearAtomSelection();
  BOOST_FOREACH(atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsOfMoleculeAction::performRedo(Action::state_ptr _state){
  SelectionAllAtomsOfMoleculeState *state = assert_cast<SelectionAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomsByMoleculeSelection());

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsOfMoleculeAction::canUndo() {
  return true;
}

bool SelectionAllAtomsOfMoleculeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
