/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AllAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "AllAtomsAction.hpp"

// and construct the stuff
#include "AllAtomsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  DoLog(1) && (Log() << Verbose(1) << "Selecting all atoms." << endl);
  World::getInstance().selectAllAtoms(AllAtoms());
  return Action::state_ptr(new SelectionAllAtomsState(selectedAtoms,params));
}

Action::state_ptr SelectionAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsState *state = assert_cast<SelectionAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();

  BOOST_FOREACH(atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsAction::performRedo(Action::state_ptr _state){
  //SelectionAllAtomsState *state = assert_cast<SelectionAllAtomsState*>(_state.get());

  World::getInstance().selectAllAtoms(AllAtoms());

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsAction::canUndo() {
  return true;
}

bool SelectionAllAtomsAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
