/*
 * ActionCalls.hpp
 *
 *  Created on: Jul 26, 2010
 *      Author: heber
 */

#ifndef ACTIONCALLS_HPP_
#define ACTIONCALLS_HPP_

#include "Actions/ActionRegistry.hpp"
#include "Box.hpp"
#include "vector.hpp"

using namespace std;

class atom;
class element;
class molecule;

void AnalysisMolecularVolume();
void AnalysisPairCorrelation(std::vector< element *> &elements, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);
void AnalysisPointCorrelation(std::vector< element *> &elements, Vector &position, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);
void AnalysisPrincipalAxisSystem();
void AnalysisSurfaceCorrelation(std::vector< element *> &elements, molecule *mol, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);

void AtomAdd(element *elemental, Vector &position);
void AtomChangeElement(element *elemental);
void AtomRemove();

void CommandBondLengthTable(std::string &BondGraphFileName);
void CommandElementDb(std::string &databasepath);
void CommandFastParsing(bool fastparsing);
void CommandHelp();
void CommandVerbose(int verbosity);
void CommandVersion();

void FragmentationDepthFirstSearch(double distance);
void FragmentationFragmentation(std::string &path, double distance, int order);
void FragmentationSubgraphDissection();

void MoleculeBondFile(std::string &bondfile);
void MoleculeChangeName(std::string &name);
void MoleculeFillWithMolecule(std::string &fillername, Vector &distances, Vector &lengths, double MaxDistance, bool DoRotate);
void MoleculeLinearInterpolationofTrajectories(std::string &filename, int start, int end, bool IdMapping);
void MoleculeRotateToPrincipalAxisSystem();
void MoleculeSaveAdjacency(std::string &adjacencyfile);
void MoleculeSaveBonds(std::string &bondsfile);
void MoleculeSaveTemperature(std::string &temperaturefile);
void MoleculeSuspendInWater(double density);
void MoleculeTranslate(Vector &x, bool periodic);
void MoleculeVerletIntegration(std::string &forcesfile);

void ParserLoadXyz(std::string &filename);
void ParserSaveXyz(std::string &filename);

void SelectionAllAtoms();
void SelectionAllMolecules();
void SelectionAtomById(atom *_atom);
void SelectionMoleculeById(molecule *_mol);
void SelectionNotAllAtoms();
void SelectionNotAllMolecules();
void SelectionNotAtomById(atom *_atom);
void SelectionNotMoleculeById(molecule *_mol);

void TesselationConvexEnvelope(std::string &filenameConvex, std::string &filenameNonConvex);
void TesselationNonConvexEnvelope(double radius, std::string &filename);

void WorldAddEmptyBoundary(Vector &boundary);
void WorldBoundInBox();
void WorldCenterInBox(Box &_box);
void WorldCenterOnEdge();
void WorldChangeBox(Box &_box);
void WorldInput(std::string &filename);
void WorldOutput();
void WorldRemoveSphereOfAtoms(double radius, Vector &point);
void WorldRepeatBox(Vector &Repeater);
void WorldScaleBox(Vector &Scaler);
void WorldSetDefaultName(std::string &defaultname);
void WorldSetGaussianBasis(std::string &basisname);
void WorldSetOutputFormats(vector<std::string> &FormatList);

#endif /* ACTIONCALLS_HPP_ */
