/*
 * TextMenu.cpp
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

#include <boost/bind.hpp>
#include <iostream>
#include <cmath>
#include "Menu/TextMenu.hpp"
#include "Menu/MenuItem.hpp"


/**
 * produce a text menu with a given title.
 * The text will later be displayed using the stream passed to the constructor.
 */
TextMenu::TextMenu(ostream& _outputter, string _title, char _spacer,int _length) :
outputter(_outputter),
title(_title),
spacer(_spacer),
length(_length),
quit(false),
defaultItem(0)
{
}

TextMenu::~TextMenu()
{
  for(list<MenuItem*>::iterator it=items.begin(); it != items.end(); it++)
    delete (*it);
}


void TextMenu::addItem(MenuItem* item) {
  items.push_back(item);
}

void TextMenu::removeItem(MenuItem* item) {
  items.remove(item);
}

void TextMenu::doQuit(){
  quit = true;
}

bool TextMenu::hasQuit(){
  return quit;
}

void TextMenu::showEntry(MenuItem* entry){
  outputter << entry->formatEntry() << "\n";
}

void TextMenu::display() {
  char choice;
  bool somethingChosen = false;
  do {
    int pre = floor((length - title.length()) /2.0);
    int post = ceil((length - title.length()) /2.0);
    for(int i=0;i<pre;i++)
      outputter << spacer;
    outputter << title;
    for(int i=0;i<post;i++)
          outputter << spacer;
    outputter << '\n';
    for_each(items.begin(), items.end(), boost::bind(&TextMenu::showEntry,this,_1));
    outputter.flush();

    cin >> choice;

    list<MenuItem*>::iterator iter;
    for(iter = items.begin(); iter!=items.end();iter++){
      somethingChosen |= (*iter)->checkTrigger(choice);
    }
    // see if something was chosen and call default Item if not
    if(!somethingChosen) {
      if(defaultItem){
        defaultItem->doTrigger();
      }
      else{
        outputter << "Invalid Choice!" <<  endl;
      }
    }
  }while (!hasQuit());
}

void TextMenu::addDefault(MenuItem* _defaultItem) {
  defaultItem = _defaultItem;
}
