/*
 * DisplayMenuItem.hpp
 *
 *  Created on: Dec 14, 2009
 *      Author: crueger
 */

#ifndef DISPLAYMENUITEM_HPP_
#define DISPLAYMENUITEM_HPP_

#include "Menu/MenuItem.hpp"
#include "defs.hpp"

class StringView;

/**
 * Display any kind of StringView within a Menu
 *
 * Any trigger are ignored for this type of Item
 */
class DisplayMenuItem : public MenuItem
{
public:
  DisplayMenuItem(Menu* _menu, StringView *_view);
  DisplayMenuItem(Menu* _menu, StringView *_view, string _title,
                  char _spacer=STD_MENU_TITLE_SPACER, int _length=STD_MENU_LENGTH);
  virtual ~DisplayMenuItem();

  virtual void doTrigger();
  virtual bool checkTrigger(char);

  virtual const string formatEntry();

  virtual const string getDescription();

private:
  StringView *view;
  string title;
  int length;
  char spacer;
};

#endif /* DISPLAYMENUITEM_HPP_ */
