/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * StringParameterUnitTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "StringParameterUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parameters/Parameter.hpp"

#include "CodePatterns/Assert.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( StringParameterTest );


void StringParameterTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);
}

void StringParameterTest::tearDown()
{
}

/************************************ tests ***********************************/

/** Unit test for comparator.
 *
 */
void StringParameterTest::comparatorTest()
{
  // create instance
  Parameter<std::string> test("stringParam");
  Parameter<std::string> samenamedsamevalued("stringParam");
  Parameter<std::string> samenamedelsevalued("stringParam");
  Parameter<std::string> elsenamedsamevalued("string2Param");
  Parameter<std::string> elsenamedelsevalued("string2Param");
  test.set(std::string("1"));
  samenamedsamevalued.set(std::string("1"));
  samenamedelsevalued.set(std::string("2"));
  elsenamedsamevalued.set(std::string("1"));
  elsenamedelsevalued.set(std::string("2"));

  CPPUNIT_ASSERT( test == samenamedsamevalued );
  CPPUNIT_ASSERT( test != samenamedelsevalued );
  CPPUNIT_ASSERT( test != elsenamedsamevalued );
  CPPUNIT_ASSERT( test != elsenamedelsevalued );
}

/** Unit test for clone.
 *
 */
void StringParameterTest::cloneTest()
{
  // create instance
  Parameter<std::string> test("intParam");

  // set parameter
  test.set(std::string("1"));

  // is returned as Parameter but we can compare only in true class as
  // Parameter may also be a DiscreteParameter where comparison is nonsense
  Parameter<std::string> *instance = dynamic_cast< Parameter<std::string> *> (test.clone());

  // different places in memory
  CPPUNIT_ASSERT( &test != instance);

  // but same contents
  CPPUNIT_ASSERT( test == *instance);
}

