/*
 * SetGaussianBasisAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/SetGaussianBasisAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "config.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class WorldSetGaussianBasisState : public ActionState {
public:
  WorldSetGaussianBasisState(std::string _lastName) :
    lastName(_lastName)
  {}
  std::string lastName;
};


const char WorldSetGaussianBasisAction::NAME[] = "set-basis";

WorldSetGaussianBasisAction::WorldSetGaussianBasisAction() :
  Action(NAME)
{}

WorldSetGaussianBasisAction::~WorldSetGaussianBasisAction()
{}

void WorldSetGaussianBasis(std::string &basisname) {
  ValueStorage::getInstance().setCurrentValue(WorldSetGaussianBasisAction::NAME, basisname);
  ActionRegistry::getInstance().getActionByName(WorldSetGaussianBasisAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldSetGaussianBasisAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldSetGaussianBasisAction::performCall() {
  config *configuration = World::getInstance().getConfig();

  string lastname = configuration->basis;
  ValueStorage::getInstance().queryCurrentValue(NAME, configuration->basis);

  DoLog(1) && (Log() << Verbose(1) << "Setting MPQC basis to " << configuration->basis << "." << endl);
  return Action::success;
}

Action::state_ptr WorldSetGaussianBasisAction::performUndo(Action::state_ptr _state) {
  WorldSetGaussianBasisState *state = assert_cast<WorldSetGaussianBasisState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  string newName = configuration->basis;
  configuration->basis = state->lastName;

  return Action::state_ptr(new WorldSetGaussianBasisState(newName));
}

Action::state_ptr WorldSetGaussianBasisAction::performRedo(Action::state_ptr _state){
  performUndo(_state);
}

bool WorldSetGaussianBasisAction::canUndo() {
  return true;
}

bool WorldSetGaussianBasisAction::shouldUndo() {
  return true;
}

const string WorldSetGaussianBasisAction::getName() {
  return NAME;
}
