/*
 * SetDefaultNameAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/SetDefaultNameAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class WorldSetDefaultNameState : public ActionState {
public:
  WorldSetDefaultNameState(std::string _lastName) :
    lastName(_lastName)
  {}
  std::string lastName;
};

const char WorldSetDefaultNameAction::NAME[] = "default-molname";

WorldSetDefaultNameAction::WorldSetDefaultNameAction() :
  Action(NAME)
{}

WorldSetDefaultNameAction::~WorldSetDefaultNameAction()
{}

void WorldSetDefaultName(std::string &defaultname) {
  ValueStorage::getInstance().setCurrentValue(WorldSetDefaultNameAction::NAME, defaultname);
  ActionRegistry::getInstance().getActionByName(WorldSetDefaultNameAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldSetDefaultNameAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  string defaultname = World::getInstance().getDefaultName();
  ValueStorage::getInstance().setCurrentValue(NAME, defaultname);
  dialog->queryString(NAME, MapOfActions::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldSetDefaultNameAction::performCall() {
  string defaultname;

  defaultname = World::getInstance().getDefaultName();
  ValueStorage::getInstance().queryCurrentValue(NAME, defaultname);

  World::getInstance().setDefaultName(defaultname);
  DoLog(0) && (Log() << Verbose(0) << "Default name of new molecules set to " << World::getInstance().getDefaultName() << "." << endl);
  return Action::success;
}

Action::state_ptr WorldSetDefaultNameAction::performUndo(Action::state_ptr _state) {
  WorldSetDefaultNameState *state = assert_cast<WorldSetDefaultNameState*>(_state.get());

  string newName = World::getInstance().getDefaultName();
  World::getInstance().setDefaultName(state->lastName);

  return Action::state_ptr(new WorldSetDefaultNameState(newName));
}

Action::state_ptr WorldSetDefaultNameAction::performRedo(Action::state_ptr _state){
  performUndo(_state);
}

bool WorldSetDefaultNameAction::canUndo() {
  return true;
}

bool WorldSetDefaultNameAction::shouldUndo() {
  return true;
}

const string WorldSetDefaultNameAction::getName() {
  return NAME;
}
