/*
 * ScaleBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/ScaleBoxAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"
#include "Box.hpp"
#include "Matrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldScaleBoxAction::NAME[] = "scale-box";

WorldScaleBoxAction::WorldScaleBoxAction() :
  Action(NAME)
{}

WorldScaleBoxAction::~WorldScaleBoxAction()
{}

void WorldScaleBox(Vector &Scaler) {
  ValueStorage::getInstance().setCurrentValue(WorldScaleBoxAction::NAME, Scaler);
  ActionRegistry::getInstance().getActionByName(WorldScaleBoxAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldScaleBoxAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryVector(NAME, false, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldScaleBoxAction::performCall() {
  Vector Scaler;
  double x[NDIM];

  ValueStorage::getInstance().queryCurrentValue(NAME, Scaler);

  DoLog(1) && (Log() << Verbose(1) << "Scaling all atomic positions by factor." << endl);
  for (int i=0;i<NDIM;i++)
    x[i] = Scaler[i];
  vector<atom*> AllAtoms = World::getInstance().getAllAtoms();
  for(vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner) {
    (*AtomRunner)->x.ScaleAll(x);
  }

  Matrix M = World::getInstance().getDomain().getM();
  Matrix scale;

  for (int i=0;i<NDIM;i++) {
    scale.at(i,i) = x[i];
  }
  M *= scale;
  World::getInstance().setDomain(M);

  return Action::success;
}

Action::state_ptr WorldScaleBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldScaleBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldScaleBoxAction::canUndo() {
  return false;
}

bool WorldScaleBoxAction::shouldUndo() {
  return false;
}

const string WorldScaleBoxAction::getName() {
  return NAME;
}
