/*
 * CenterOnEdgeAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/CenterOnEdgeAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "vector.hpp"
#include "World.hpp"
#include "Matrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"
#include "Helpers/Assert.hpp"

const char WorldCenterOnEdgeAction::NAME[] = "center-edge";

WorldCenterOnEdgeAction::WorldCenterOnEdgeAction() :
  Action(NAME)
{}

WorldCenterOnEdgeAction::~WorldCenterOnEdgeAction()
{}

void WorldCenterOnEdge() {
  ActionRegistry::getInstance().getActionByName(WorldCenterOnEdgeAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldCenterOnEdgeAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldCenterOnEdgeAction::performCall() {
  Vector Min;
  Vector Max;

  // get maximum and minimum
  vector<atom *> AllAtoms = World::getInstance().getAllAtoms();
  ASSERT(AllAtoms.size() > 0, "For CenteronEdge atoms must be present.");
  vector<atom *>::iterator AtomRunner = AllAtoms.begin();
  Min = (*AtomRunner)->x;
  Max = (*AtomRunner)->x;
  for (; AtomRunner != AllAtoms.end(); ++AtomRunner) {
    for (int i=0;i<NDIM;i++) {
      if ((*AtomRunner)->x[i] > Max[i])
        Max[i] = (*AtomRunner)->x[i];
      if ((*AtomRunner)->x[i] < Min[i])
        Min[i] = (*AtomRunner)->x[i];
    }
  }
  // set new box size
  Matrix domain;
  for (int i=0;i<NDIM;i++) {
    double tmp = Max[i]-Min[i];
    tmp = fabs(tmp)>=1. ? tmp : 1.0;
    domain.at(i,i) = tmp;
  }
  World::getInstance().setDomain(domain);
  // translate all atoms, such that Min is aty (0,0,0)
  for (vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner)
    (*AtomRunner)->x -= Min;

  return Action::success;
}

Action::state_ptr WorldCenterOnEdgeAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldCenterOnEdgeAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldCenterOnEdgeAction::canUndo() {
  return false;
}

bool WorldCenterOnEdgeAction::shouldUndo() {
  return false;
}

const string WorldCenterOnEdgeAction::getName() {
  return NAME;
}
