/*
 * BoundInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/BoundInBoxAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>
#include <vector>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldBoundInBoxAction::NAME[] = "bound-in-box";

WorldBoundInBoxAction::WorldBoundInBoxAction() :
  Action(NAME)
{}

WorldBoundInBoxAction::~WorldBoundInBoxAction()
{}

void WorldBoundInBox() {
  ActionRegistry::getInstance().getActionByName(WorldBoundInBoxAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldBoundInBoxAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldBoundInBoxAction::performCall() {

  // center
  vector<molecule*> AllMolecules = World::getInstance().getAllMolecules();
  for (vector<molecule*>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
    (*MolRunner)->BoundInBox();
  }
  return Action::success;
}

Action::state_ptr WorldBoundInBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldBoundInBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldBoundInBoxAction::canUndo() {
  return false;
}

bool WorldBoundInBoxAction::shouldUndo() {
  return false;
}

const string WorldBoundInBoxAction::getName() {
  return NAME;
}
