/** \file PotentialTypes.hpp
 *
 * This is a enhanced enumeration to make it usable within a loop.
 *
 *  date: Apr, 09 2013
 *  author: heber
 *
 */

#ifndef POTENTIALTYPES_HPP_
#define POTENTIALTYPES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/seq/elem.hpp>
#include <boost/preprocessor/seq/seq.hpp>
#include <boost/preprocessor/seq/size.hpp>
#include <boost/preprocessor/iteration/local.hpp>


#include "PotentialTypes.def"

//!> function to print each member of the sequence in the enumeration
#define sequence_print(z,n,seq) \
  BOOST_PP_SEQ_ELEM(n, seq) ,

  //!> enumeration of all known and createable potentials
enum PotentialTypes {
// some proprocessor magic to generate the body from the above sequence
#if defined PotentialTypes_END // do we have parameters at all?
#define BOOST_PP_LOCAL_MACRO(n) sequence_print(~, n, POTENTIALSEQUENCE)
#define BOOST_PP_LOCAL_LIMITS  (0, PotentialTypes_END-1)
#include BOOST_PP_LOCAL_ITERATE()
#undef BOOST_PP_LOCAL_MACRO
#undef BOOST_PP_LOCAL_LIMITS
#endif
  PotentialTypes_end = PotentialTypes_END,
  PotentialTypes_begin = BOOST_PP_SEQ_HEAD(POTENTIALSEQUENCE)
};

#undef sequence_print

//!> Number of known PotentialTypes
const size_t PotentialTypesMax = PotentialTypes_END;

#include "PotentialTypes.undef"

//!> Typedef for enumeration to ease its use
typedef enum PotentialTypes PotentialTypes;

/** Increment operator for the enumeration PotentialTypes to allow loops.
 * \param &type value
 * \return value incremented by one
 */
PotentialTypes &operator++(PotentialTypes &type);

#endif /* POTENTIALTYPES_HPP_ */

