/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SubgraphDissectionAction.cpp
 *
 *  Created on: Mar 1, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Chronos.hpp"

#include "Actions/GraphAction/CreateAdjacencyAction.hpp"
#include "Actions/GraphAction/DestroyAdjacencyAction.hpp"
#include "Actions/GraphAction/UpdateMoleculesAction.hpp"
#include "Actions/GraphAction/SubgraphDissectionAction.hpp"
#include "Actions/SelectionAction/Atoms/PushAtomsAction.hpp"
#include "Actions/SelectionAction/Atoms/PopAtomsAction.hpp"
#include "Actions/SelectionAction/Atoms/AllAtomsAction.hpp"
#include "Actions/ActionQueue.hpp"
#include "Actions/ActionRegistry.hpp"

#include "Descriptors/AtomDescriptor.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SubgraphDissectionAction.def"
#include "MakroAction_impl_pre.hpp"
/** =========== define the function ====================== */

// static instances
ActionSequence GraphSubgraphDissectionAction::actions;
bool GraphSubgraphDissectionAction::isPrepared = false;

void GraphSubgraphDissectionAction::prepare(ActionRegistry &AR)
{
  actions.addAction(AR.getActionByName(std::string("push-atom-selection")));
  actions.addAction(AR.getActionByName(std::string("select-all-atoms")));
  actions.addAction(AR.getActionByName(std::string("destroy-adjacency")));
  actions.addAction(AR.getActionByName(std::string("create-adjacency")));
  actions.addAction(AR.getActionByName(std::string("update-molecules")));
  actions.addAction(AR.getActionByName(std::string("pop-atom-selection")));
  isPrepared = true;
}

void GraphSubgraphDissectionAction::unprepare(ActionRegistry &AR)
{
  // empty sequence
  while (actions.removeLastAction() != NULL);
  isPrepared = false;
}

ActionState::ptr GraphSubgraphDissectionAction::performCall(){
  ActionState::ptr state(MakroAction::performCall());

  return state;
}

ActionState::ptr GraphSubgraphDissectionAction::performUndo(ActionState::ptr _state) {
  ActionState::ptr state(MakroAction::performUndo(_state));

  return state;
}

ActionState::ptr GraphSubgraphDissectionAction::performRedo(ActionState::ptr _state){
  ActionState::ptr state(MakroAction::performRedo(_state));

  return state;
}

bool GraphSubgraphDissectionAction::canUndo(){
  return true;
}

bool GraphSubgraphDissectionAction::shouldUndo(){
  return true;
}
