/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NotAllShapesAction.cpp
 *
 *  Created on: Sep 14, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Shapes/ShapeRegistry.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "NotAllShapesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAllShapesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllShapesAction::performCall() {
  std::vector<Shape *> selectedShapes= ShapeRegistry::getInstance().getSelectedShapes();
  LOG(1, "Unselecting all shapes.");
  ShapeRegistry::getInstance().unselectAllShapes();
  LOG(0, ShapeRegistry::getInstance().countSelectedShapes() << " shapes remain selected.");
  return Action::state_ptr(new SelectionNotAllShapesState(selectedShapes,params));
}

Action::state_ptr SelectionNotAllShapesAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllShapesState *state = assert_cast<SelectionNotAllShapesState*>(_state.get());

  ShapeRegistry::getInstance().unselectAllShapes();

  BOOST_FOREACH(Shape *shape, state->selectedShapes)
  ShapeRegistry::getInstance().selectShape(shape);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllShapesAction::performRedo(Action::state_ptr _state){
  //SelectionNotAllShapesState *state = assert_cast<SelectionNotAllShapesState*>(_state.get());

  ShapeRegistry::getInstance().unselectAllShapes();

  return Action::state_ptr(_state);
}

bool SelectionNotAllShapesAction::canUndo() {
  return true;
}

bool SelectionNotAllShapesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
