/*
 * VMGDataMap.hpp
 *
 *  Created on: Aug 8, 2012
 *      Author: heber
 */

#ifndef VMGDATAMAP_HPP_
#define VMGDATAMAP_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/fusion/container/map.hpp>
#include <boost/mpl/list.hpp>

#include "Jobs/VMGDataFused.hpp"

class SamplingGrid;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all sampled_grid data members in VMGData and their type.
 *
 * This lets us resolves any ambiguitites of types in VMGData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<VMGDataFused::sampled_potential, SamplingGrid >,
    boost::fusion::pair<VMGDataFused::energy_potential, double >,
    boost::fusion::pair<VMGDataFused::energy_long, double >
> VMGDataMap_t;

typedef boost::mpl::list<
    VMGDataFused::sampled_potential,
    VMGDataFused::energy_potential,
    VMGDataFused::energy_long
> VMGDataVector_t;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all sampled_grid data members in VMGData and their type.
 *
 * This lets us resolves any ambiguitites of types in VMGData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<VMGDataFused::potential_longrange, double >,
    boost::fusion::pair<VMGDataFused::potential_shortrange, double >,
    boost::fusion::pair<VMGDataFused::energy_longrange, double >,
    boost::fusion::pair<VMGDataFused::energy_shortrange, double >
> VMGDataLongRangeMap_t;

typedef boost::mpl::list<
    VMGDataFused::potential_longrange,
    VMGDataFused::potential_shortrange,
    VMGDataFused::energy_longrange,
    VMGDataFused::energy_shortrange
> VMGDataLongRangeVector_t;


#endif /* VMGDATAMAP_HPP_ */
