/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * LinkedCell_Model_Update.cpp
 *
 *  Created on: Dec 20, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "LinkedCell_Model_Update.hpp"


/** Constructor for class Update.
 *
 * @param _updateMethod bound function with update method
 * @param _Walker node on which the update works
 * @param _priority priority of the update (the lower, the more important)
 */
LinkedCell::LinkedCell_Model::Update::Update(boost::function<void (const TesselPoint *)> _updateMethod, const TesselPoint *_Walker, const PriorityLevel _priority, const std::string _name) :
  updateMethod(_updateMethod),
  Walker(_Walker),
  priority(_priority),
  name(_name)
{}

/** Destructor of class Update.
 *
 */
LinkedCell::LinkedCell_Model::Update::~Update()
{}

/** The actual update operation working on \a Walker.
 *
 */
void LinkedCell::LinkedCell_Model::Update::operator()() {
  updateMethod(Walker);
}
