/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ObservedValue_threeNumbers.cpp
 *
 *  Created on: Jun 19, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "ObservedValue_threeNumbers.hpp"

#include "CodePatterns/Observer/Channels.hpp"

void ObservedValue_threeNumbers::setX(int _x)
{
  OBSERVE;
  NOTIFY(XChanged);
  x = _x;
}

void ObservedValue_threeNumbers::setY(int _y)
{
  OBSERVE;
  NOTIFY(YChanged);
  y = _y;
}

void ObservedValue_threeNumbers::setZ(int _z)
{
  OBSERVE;
  NOTIFY(ZChanged);
  z = _z;
}

int ObservedValue_threeNumbers::calcSum() const
{
  hasRecalced = true;
  return x+y+z;
}

ObservedValue_threeNumbers::ObservedValue_threeNumbers(
    int _x,
    int _y,
    int _z,
    Observable::channels_t channels) :
  Observable(
      "ObservedValue_threeNumbers",
      Observable::getChannelList(ObservedValue_threeNumbers::NotificationType_MAX)),
  x(_x),y(_y),z(_z),
  sum(this,boost::bind(&ObservedValue_threeNumbers::calcSum,this),"sum", calcSum(), channels),
  hasRecalced(false)
{}
