/*
 * atom_trajectoryparticle.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_TRAJECTORYPARTICLE_HPP_
#define ATOM_TRAJECTORYPARTICLE_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>

#include <gsl/gsl_randist.h>

#include "atom_atominfo.hpp"
#include "atom_particleinfo.hpp"
#include "atom_trajectoryparticleinfo.hpp"

/****************************************** forward declarations *****************************/

class atom;
class config;
class ForceMatrix;
class Vector;

/********************************************** declarations *******************************/


class TrajectoryParticle :  public TrajectoryParticleInfo, public virtual AtomInfo, public virtual ParticleInfo {
public:

  TrajectoryParticle();
  virtual ~TrajectoryParticle();

  // constraint potential and dynamics stuff
  void EvaluateConstrainedForce(int startstep, int endstep, atom **PermutationMap, ForceMatrix *Force) const;
  void CorrectVelocity(double *ActualTemp, int Step, Vector *CoGVelocity);

  // trajectory stuff
  void ResizeTrajectory(int MaxSteps);
  void CopyStepOnStep(int dest, int src);
  void VelocityVerletUpdate(int MDSteps, config *configuration, ForceMatrix *Force, const size_t offset);
  double getKineticEnergy(unsigned int step) const;
  Vector getMomentum(unsigned int step) const;

  std::ostream & operator << (std::ostream &ost) const;

private:
};

ostream & operator << (ostream &ost, const TrajectoryParticle &a);

#endif /* ATOM_TRAJECTORYPARTICLE_HPP_ */
