/*
 * Shape_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPE_IMPL_HPP_
#define SHAPE_IMPL_HPP_

#include "Shapes/Shape.hpp"

class Shape_impl {
public:
  virtual bool isInside(const Vector &point)=0;
};

class Everywhere_impl : public Shape_impl {
public:
  virtual bool isInside(const Vector &point){
    return true;
  }
};

class Nowhere_impl : public Shape_impl {
  virtual bool isInside(const Vector &point){
    return false;
  }
};

class AndShape_impl : public Shape_impl {
public:
  AndShape_impl(const Shape::impl_ptr&, const Shape::impl_ptr&);
  virtual ~AndShape_impl();
  virtual bool isInside(const Vector &point);
private:
  Shape::impl_ptr lhs;
  Shape::impl_ptr rhs;
};

class OrShape_impl : public Shape_impl {
public:
  OrShape_impl(const Shape::impl_ptr&, const Shape::impl_ptr&);
  virtual ~OrShape_impl();
  virtual bool isInside(const Vector &point);
private:
  Shape::impl_ptr lhs;
  Shape::impl_ptr rhs;
};

class NotShape_impl : public Shape_impl {
public:
  NotShape_impl(const Shape::impl_ptr&);
  virtual ~NotShape_impl();
  virtual bool isInside(const Vector &point);
private:
  Shape::impl_ptr arg;
};

#endif /* SHAPE_IMPL_HPP_ */
