/*
 * Shape.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPE_HPP_
#define SHAPE_HPP_

#include <boost/shared_ptr.hpp>

class Vector;
class Shape_impl;

class Shape
{
friend Shape operator&&(const Shape&,const Shape&);
friend Shape operator||(const Shape&,const Shape&);
friend Shape operator!(const Shape&);
public:
  typedef boost::shared_ptr<Shape_impl> impl_ptr;

  Shape(impl_ptr);
  Shape(const Shape&);
  virtual ~Shape();

  bool isInside(const Vector &point);

  Shape &operator=(const Shape& rhs);

protected:
  impl_ptr getImpl() const;

private:
  impl_ptr impl;
};

Shape Everywhere();
Shape Nowhere();

Shape operator&&(const Shape&,const Shape&);
Shape operator||(const Shape&,const Shape&);
Shape operator!(const Shape&);

#endif /* SHAPE_HPP_ */
