/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ObserverStub.cpp
 *
 *  Created on: Dec 19, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Observer/Observer.hpp"

#include <cppunit/extensions/HelperMacros.h>

#include "ObserverStub.hpp"

/************ UpdateCountObserver **************/

UpdateCountObserver::UpdateCountObserver() :
  Observer("UpdateCountObserver"),
  updates(0)
{};

UpdateCountObserver::~UpdateCountObserver()
{}

void UpdateCountObserver::update(Observable *publisher){
  updates++;
}

void UpdateCountObserver::subjectKilled(Observable *publisher) {
}

NotificationObserver::NotificationObserver(Notification_ptr notification) :
  Observer("NotificationObserver"),
  requestedNotification(notification),
  wasNotified(false)
{}

/*********** NotificationObserver **************/

NotificationObserver::~NotificationObserver()
{}

void NotificationObserver::update(Observable*){}
void NotificationObserver::subjectKilled(Observable*){}
void NotificationObserver::recieveNotification(Observable *publisher, Notification_ptr notification){
  CPPUNIT_ASSERT(requestedNotification==notification);
  wasNotified = true;
}
